;**************************************
; Test SPEAKER ON PORTB.2
; Hardware  : CP-PIC877/18F442/458
; OSC	    : 10 MHZ [HS MODE]
; Assembler : mpasm.exe
; Programmer: WATCHARIN KAOROP
; Company   : ETT  CO.,LTD.
; Date      : 6/8/2002
;**************************************

     list p=16f877                 ; list directive to define processor
     #include <p16f877.inc>        ; processor specific variable definitions
    __CONFIG _CP_OFF & _WDT_OFF & _BODEN_ON & _PWRTE_ON & _HS_OSC & _WRT_ENABLE_ON & _LVP_OFF & _DEBUG_OFF & _CPD_OFF
         
	DT0       EQU       0X20
        DT1       EQU       0x21
        DT2       EQU       0x22
	COUNT     EQU       0X23

	   ORG       0x0000

MAIN      bsf       STATUS,RP0         ; select bank 1
          clrf      TRISB              ; All PORTB is output
          bcf       STATUS,RP0         ; select bank 0

NOW       MOVLW     0X7F
          MOVWF     COUNT
          CALL      DELAY
PULSE     BSF       PORTB,2            ;      __    __
	  CALL      SDEL               ;   __|  |__|
	  BCF       PORTB,2
	  CALL      SDEL
	  DECFSZ    COUNT
	  GOTO      PULSE
	  GOTO      NOW

;********* DELAY LOOP ********

DELAY     MOVLW     0X02
	  MOVWF     DT0
DELY      CLRF      DT1
DELY2     CLRF      DT2
DELY1     DECFSZ    DT2
          GOTO      DELY1
          DECFSZ    DT1
          GOTO      DELY2
	  DECFSZ    DT0
	  GOTO      DELY
          RETURN 

;******* Shot Delay *********
 
SDEL      CLRF      DT2
SD1       DECFSZ    DT2
          GOTO      SD1
          RETURN 

	 END    
